@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Lojas - {{ $pot->estadual }}</div>
        <div class="right" id="favorito">

        </div>
    </div>
    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="listview-title mt-2">{{utf8_decode($cidade)}}</div>
        <ul class="listview link-listview search-result mb-2">
            @foreach ($lojas as $loja)
                <li>
                    <a href="{{route('app.loja',$loja->id)}}">
                        <div>
                            <h4 class="mb-05">{{utf8_decode($loja->loja)}} - {{$loja->numero}}</h4>
                            <div class="text-muted">
                                Ven.·. M.·. {{$loja->vm}}<br>
                                Reuniões: {{utf8_decode($loja->reunioes)}} às {{$loja->horario}}<br>
                                <div class="mt-05"><strong>{{utf8_decode($loja->endereco)}},{{utf8_decode($loja->numero)}},{{utf8_decode($loja->bairro)}}</strong></div>
                            </div>
                        </div>
                    </a>
                </li>
            @endforeach
        </ul>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')

@endsection
